<?php
session_start();

// Debug session role
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

$message = []; // Initialize $message as an empty array

// Check if form is submitted and images are provided
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if ($_SERVER["REQUEST_METHOD"] == "POST" && !empty($_FILES['images']['name'][0])) {
        $target_dir = "uploads/";

        foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
            if (!empty($_FILES['images']['name'][$key])) {
                $file_name = basename($_FILES['images']['name'][$key]);
                $target_file = $target_dir . $file_name;
                $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

                // Validate file type and check if it's an image
                $check = getimagesize($tmp_name);
                if ($check === false) {
                    $message[] = "$file_name is not an image.";
                    continue;
                }

                if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
                    $message[] = "$file_name has an invalid file type. Only JPG, JPEG, PNG, and GIF are allowed.";
                    continue;
                }

                if (file_exists($target_file)) {
                    $message[] = "Sorry, $file_name already exists.";
                    continue;
                }

                if (move_uploaded_file($tmp_name, $target_file)) {
                    $message[] = "$file_name uploaded successfully!";
                } else {
                    $message[] = "There was an error uploading $file_name.";
                }
            }
        }
    } else {
        $message[] = "No files selected. Please choose images to upload.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
        <title>Cardiff Car Care</title>
    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenuAdmin.php"?>
    

<!-- The Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
  <?php include"login.php"?>
</div>


<script>
    // Get login status from PHP (true if logged in, false otherwise)
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    // Function to show the login modal
    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    // Execute after page loads
    window.onload = function () {
        // Show the modal only if the user is NOT logged in
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500); // Show after 2.5 seconds
        }
    };

    // Close the modal when clicking outside of it
    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>


<div class="container">   <h2>Upload Image</h2></div>
 


<div class="container">
<?php if (!empty($message)): ?>
        <ul>
            <?php foreach ($message as $msg): ?>
                <li><?php echo htmlspecialchars($msg); ?></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>

    <form action="upload_image.php" method="POST" enctype="multipart/form-data">
        <label>Select Images to Upload (max 7 at one time): </label>
        <input type="file" name="images[]" multiple required>
        <button type="submit">Upload Images</button>
    </form>

</div>
<?php include"footer.php"?>

</body>
</html>
