<?php
session_start();

// Check if the user is an admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

require_once __DIR__ . "/config/db.php";


// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $signup_id = $_POST['signup_id']; // User ID from form
    $action = $_POST['action']; // Action value ('admin', 'user', or 'delete')

    if ($action === 'delete') {
        // Prepare the SQL query to delete the user
        $sql = "DELETE FROM signup WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $signup_id);

        // Execute the query and provide feedback
        if ($stmt->execute()) {
            echo "User deleted successfully.";
        } else {
            echo "Failed to delete user: " . $stmt->error;
        }
        $stmt->close();
    } else {
        // Determine the new role
        $new_role = ($action === 'admin') ? 'admin' : 'user';

        // Prepare the SQL query to update the user's role
        $sql = "UPDATE signup SET role = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $new_role, $signup_id);

        // Execute the query and provide feedback
        if ($stmt->execute()) {
            echo "Role updated successfully.";
        } else {
            echo "Failed to update role: " . $stmt->error;
        }
        $stmt->close();
    }
}

// Close the database connection
$conn->close();
header("Location: Manage_users.php");
exit();
?>



