<?php
session_start();

// Check if the user is an admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

// Connect to the database
require_once __DIR__ . "/config/db.php";


// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $contactid = $_POST['contactid']; // User ID from form
    $action = $_POST['action']; // Action value ('read', 'unread')

    if ($action === 'delete') {
        // Prepare the SQL query to delete the user
        $sql = "DELETE FROM customer WHERE contactid = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $contactid);

        // Execute the query and provide feedback
        if ($stmt->execute()) {
            echo "message deleted successfully.";
        } else {
            echo "Failed to delete message: " . $stmt->error;
        }
        $stmt->close();
    } else {

        // Determine the new role
        $new_status = ($action === 'Unread') ? 'Unread' : 'Read';

        // Prepare the SQL query to update the user's role
        $sql = "UPDATE customer SET status = ? WHERE contactid = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $new_status, $contactid);

        // Execute the query and provide feedback
        if ($stmt->execute()) {
            echo "status updated successfully.";
        } else {
            echo "Failed to update status: " . $stmt->error;
        }
        $stmt->close();
    }
}


// Close the database connection
$conn->close();
header("Location: manage_messages.php");
exit();
?>


