<?php
// Start the session
session_start();

// Check if form is submitted via POST method
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the email and password from the form, trimming whitespace
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Check if both fields are filled
    if (empty($email) || empty($password)) {
        header("Location: Home.php?error=Please enter both email and password");
        exit();
    }

    require_once __DIR__ . "/config/db.php";


    // Prepare the SQL query to find user details
    $stmt = $conn->prepare("SELECT id, firstname, role, password FROM signup WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    // Check if the email exists
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($user_id, $firstname, $role, $hashed_password);
        $stmt->fetch();

        // Verify password
        if (password_verify($password, $hashed_password)) {
            // Successful login - start session
            $_SESSION['loggedin'] = true;
            $_SESSION['email'] = $email;
            $_SESSION['user_id'] = $user_id;
            $_SESSION['firstname'] = $firstname;
            $_SESSION['role'] = $role;

            // Redirect to homepage (or admin panel if needed)
            header("Location: Home.php");
            exit();
        } else {
            // Incorrect password
            header("Location: Home.php?error=Incorrect password. Please try again.");
            exit();
        }
    } else {
        // Email not found
        header("Location: Home.php?error=No account found with that email.");
        exit();
    }

    // Close database connection
    $stmt->close();
    $conn->close();
} else {
    // Redirect if accessed without form submission
    header("Location: Home.php");
    exit();
}
?>
