<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

require_once __DIR__ . "/config/db.php";

// Fetch service data
if (isset($_GET['id'])) {
    $id = $conn->real_escape_string($_GET['id']);
    $sql = "SELECT * FROM services WHERE id='$id'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $service = $result->fetch_assoc();
    } else {
        die("Service not found!");
    }
} else {
    die("No service ID provided!");
}

// Get list of existing images from 'uploads' folder
$uploads_dir = "uploads/";
$images = array_diff(scandir($uploads_dir), array('..', '.'));

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $service_name = $conn->real_escape_string($_POST['service_name']);
    $service_overview = $conn->real_escape_string($_POST['service_overview']);
    $detailed_description = $conn->real_escape_string($_POST['detailed_description']);
    $price = $conn->real_escape_string($_POST['price']);
    $image_url = $conn->real_escape_string($_POST['selected_image']); // Image selected from dropdown

    // Update query
    $sql = "UPDATE services SET 
                service_name='$service_name',
                service_overview='$service_overview',
                detailed_description='$detailed_description',
                price='$price',
                image_url='$uploads_dir$image_url'
            WHERE id='$id'";

    if ($conn->query($sql) === TRUE) {
        // ✅ Redirect with a success message
        header("Location: Manage_services.php?success=" . urlencode("Service updated successfully!"));
        exit();
    } else {
        header("Location: Manage_services.php?error=" . urlencode("Error updating service: " . $conn->error));
        exit();
    }
}

$conn->close();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
    <title>Cardiff Car Care</title>

    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.tiny.cloud/1/gbww066ri5k6yqv0ic4r985zd20zifcrlav1avihz63conj8/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: 'textarea#service_description',
            menubar: false,
            plugins: 'advlist autolink lists link charmap preview',
            toolbar: 'bold italic underline | bullist numlist | alignleft aligncenter alignright',
            content_style: "body { font-family: Arial; font-size: 14px; }"
        });
    </script>
</head>
<body>

<?php include"header.php"?>


<div id="mySidepanel" class="sidepanel">
    <?php include "NavMenuAdmin.php" ?>
</div>

<!-- Login Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
    <?php include "login.php" ?>
</div>

<script>
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    window.onload = function () {
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500);
        }
    };

    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>

<div class="container">
    <h2>Edit Services</h2>

    <form action="edit_service.php?id=<?= $service['id'] ?>" method="post">
        <input type="hidden" name="id" value="<?= $service['id'] ?>">

        <label for="service_name">Service Name:</label>
        <input type="text" id="service_name" name="service_name" value="<?= $service['service_name'] ?>" required>

        <label for="service_overview">Service Overview:</label>
        <textarea id="service_overview" name="service_overview" rows="5" required><?= $service['service_overview'] ?></textarea>

        <label for="service_description">Detailed Description:</label>
        <textarea id="service_description" name="detailed_description" rows="15" required><?= $service['detailed_description'] ?></textarea>

        <label for="price">Price (£):</label>
        <input type="number" id="price" name="price" step="0.01" value="<?= $service['price'] ?>" required>

        <label for="selected_image">Select an Image:</label>
        <select id="selected_image" name="selected_image" required>
            <option value="">-- Select an Image --</option>
            <?php foreach ($images as $image): ?>
                <option value="<?= htmlspecialchars($image) ?>" <?= ($uploads_dir . $image == $service['image_url']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($image) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <p>Current Image: <strong><?= basename($service['image_url']) ?></strong></p>

        <input type="submit" name="action" value="Update Service">
    </form>
</div>
<?php include"footer.php"?>

</body>
</html>
