<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: Home.php"); // Redirect guests
    exit();
}

require_once __DIR__ . "/config/db.php";


$user_id = $_SESSION['user_id']; // Ensure user ID is available in session

// Handle Review Updates and Deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $review_id = $_POST['review_id'];
    $action = $_POST['action'];

    if ($action === 'delete') {
        $delete_sql = "DELETE FROM reviews WHERE id = ? AND user_id = ?";
        $delete_stmt = $conn->prepare($delete_sql);
        $delete_stmt->bind_param("ii", $review_id, $user_id);
        if ($delete_stmt->execute()) {
            $message = "Review deleted successfully!";
        } else {
            $message = "Failed to delete review.";
        }
    } elseif ($action === 'edit') {
        $new_review_text = trim($_POST['new_review_text']);
        $update_sql = "UPDATE reviews SET review_text = ? WHERE id = ? AND user_id = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("sii", $new_review_text, $review_id, $user_id);
        if ($update_stmt->execute()) {
            $message = "Review updated successfully!";
        } else {
            $message = "Failed to update review.";
        }
    }
}

// Fetch user-specific reviews
$sql = "SELECT * FROM reviews WHERE user_id = ? ORDER BY id DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    <title>Cardiff Car Care</title>
    <link rel="icon" type="image/x-icon" href="/my-app/uploads/Cameronsautocare.png">

    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenu.php"?>

<!-- The Modal -->
<div id="loginModal" class="modal-login">
  <?php include"login.php"?>
</div>

<script>
// Get the modal-login
var modal = document.getElementById('loginModal');

// When the user clicks anywhere outside of the modal-login, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}
</script>
    <div class="container">
    <h2>Your Reviews</h2>
    </div>
    <?php if (isset($message)): ?>
        <p style="color: green; font-weight: bold;"><?php echo htmlspecialchars($message); ?></p>
    <?php endif; ?>

    <table class="styled-table">
        <tr>
            <th>Review ID</th>
            <th>Account ID</th>
            <th>Name</th>
            <th>Rating</th>
            <th>Review</th>
            <th>Date</th>
            <th>Actions</th>
        </tr>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo $row['user_id']; ?></td>
                    <td><?php echo htmlspecialchars($row['name1']); ?></td>
                    <td><?php echo htmlspecialchars($row['rating']); ?></td>
                    <td><?php echo htmlspecialchars($row['review_text']); ?></td>
                    <td><?php echo htmlspecialchars($row['review_date']); ?></td>
                    <td>
                        <!-- Edit Review Form -->
                        <form action="view_reviews.php" method="POST" style="display:inline;">
                            <input type="hidden" name="review_id" value="<?php echo $row['id']; ?>">
                            <textarea name="new_review_text" required><?php echo htmlspecialchars($row['review_text']); ?></textarea>
                            <button type="submit" name="action" value="edit">Update</button>
                        </form>

                        <!-- Delete Review Form -->
                        <form action="view_reviews.php" method="POST" style="display:inline;">
                            <input type="hidden" name="review_id" value="<?php echo $row['id']; ?>">
                            <button type="submit" name="action" value="delete" style="color:red;">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="6">No reviews found.</td>
            </tr>
        <?php endif; ?>
    </table>
    <div class="container">
    <center><a href="leave_review.php" class="button" target = "_self" >Leave a Review</a></center>

    <hr>
<!-- Contact Section -->
<section id="contact" class="contact-text">
        <h2>Contact Us</h2>
        <p> Cardiff, Wales</p>
        <p> <i style="font-size:30px" class="fa">&#xf095;</i><span style= "padding-left: 15px;">07896655867</span></p>
        <p> <i style="font-size:30px" class="fa">&#xf0e0;</i><span style= "padding-left: 15px;"><a href="mailto:info@carcarecardiff.com">info@carcarecardiff.com</a></span></p>
        </section>
        <br>
        <centre><a href="Contact.php" class="button-contact-still" target = "_self" ><i style = "font-size:20px" class="fa">&#x1F604;</i><span style = "padding-left:10px;">Contact Us</a></span></centre>

</div>

<?php include"footer.php"?>

</body>
</html>

<?php
$conn->close();
?>
