<?php
session_start();

// Redirect if not admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

require_once __DIR__ . "/config/db.php";


// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate inputs
    if (!isset($_POST['service_name'], $_POST['service_overview'], $_POST['detailed_description'], $_POST['price'], $_POST['selected_image'])) {
        $_SESSION['error_message'] = "Missing required fields!";
        header("Location: Manage_services.php");
        exit();
    }

    // Escape input data
    $service_name = $conn->real_escape_string($_POST['service_name']);
    $service_overview = $conn->real_escape_string($_POST['service_overview']);
    $detailed_description = $conn->real_escape_string($_POST['detailed_description']);
    $price = floatval($_POST['price']);
    $selected_image = $conn->real_escape_string($_POST['selected_image']);

    // Ensure selected image exists in uploads folder
    $uploads_dir = "uploads/";
    $images = array_diff(scandir($uploads_dir), array('..', '.'));
    if (!in_array($selected_image, $images)) {
        $_SESSION['error_message'] = "Invalid image selected!";
        header("Location: Manage_services.php");
        exit();
    }

    $image_url = $uploads_dir . $selected_image; // Full image path

    // Insert into database
    $stmt = $conn->prepare("INSERT INTO services (service_name, service_overview, detailed_description, price, image_url) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssds", $service_name, $service_overview, $detailed_description, $price, $image_url);

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "New service added successfully!";
    } else {
        $_SESSION['error_message'] = "Error adding service: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();

    header("Location: Manage_services.php");
    exit();
}
?>
