<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php"); // Redirect non-admins
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
        <title>Cardiff Car Care</title>
    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenuAdmin.php"?>
    

<!-- The Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
  <?php include"login.php"?>
</div>


<script>
    // Get login status from PHP (true if logged in, false otherwise)
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    // Function to show the login modal
    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    // Execute after page loads
    window.onload = function () {
        // Show the modal only if the user is NOT logged in
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500); // Show after 2.5 seconds
        }
    };

    // Close the modal when clicking outside of it
    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>
<div class="container">
  <h2>Manage Users</h2>
</div>
<?php
require_once __DIR__ . "/config/db.php";


  // Fetch users from the signup table
  $sql = "SELECT * FROM signup ORDER BY id DESC";
  $result = $conn->query($sql);

  echo "<table class='styled-table'>
          <tr>
              <th>ID</th>
              <th>Firstname</th>
              <th>Lastname</th>
              <th>Phone</th>
              <th>Email</th>
              <th>Role</th>
              <th>Actions</th>
          </tr>";

  while ($row = $result->fetch_assoc()) {
    $rowClass = ($row['role'] === 'admin') ? 'admin-row' : 'user-row';

      echo "<tr class='{$rowClass}'>
              <td>{$row['id']}</td>
              <td>{$row['firstname']}</td>
              <td>{$row['lastname']}</td>
              <td>{$row['phone']}</td>
              <td>{$row['email']}</td>
              <td>{$row['role']}</td>
              <td>
                  <form action='process_user_action.php' method='POST'>
                      <input type='hidden' name='signup_id' value='{$row['id']}'>
                      <button type='submit' name='action' value='user'>Set as User</button>
                      <button type='submit' name='action' value='admin'>Set as Admin</button>
                      <button type='submit' name='action' value='delete' style='color:red;'>Delete</button>

                      </form>
              </td>
          </tr>";
  }

  echo "</table>";

  $conn->close();
  ?>
</div>
<?php include"footer.php"?>

  </body>
  </html>