<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php"); // Redirect non-admins
    exit();
}
require_once __DIR__ . "/config/db.php";


// Handle deletion
if (isset($_GET['delete_id'])) {
    $delete_id = $conn->real_escape_string($_GET['delete_id']);
    $sql = "DELETE FROM services WHERE id='$delete_id'";
    if ($conn->query($sql) === TRUE) {
        echo "<p style='color: green;'>Service deleted successfully!</p>";
    } else {
        echo "<p style='color: red;'>Error deleting service: " . $conn->error . "</p>";
    }
}

// Fetch all services
$sql = "SELECT * FROM services";
$result = $conn->query($sql);
?>
<?php


// Display success or error messages
if (isset($_GET['success'])) {
    echo "<p style='color: green; font-weight: bold;'>" . htmlspecialchars($_GET['success']) . "</p>";
}

if (isset($_GET['error'])) {
    echo "<p style='color: red; font-weight: bold;'>" . htmlspecialchars($_GET['error']) . "</p>";
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
        <title>Cardiff Car Care</title>
    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script>
        // Display a pop-up if there's a message
        window.onload = function() {
            <?php if (isset($_SESSION['success_message'])): ?>
                alert("<?= $_SESSION['success_message'] ?>");
                <?php unset($_SESSION['success_message']); ?>  // Clear message after showing
            <?php endif; ?>

            <?php if (isset($_SESSION['error_message'])): ?>
                alert("<?= $_SESSION['error_message'] ?>");
                <?php unset($_SESSION['error_message']); ?>  // Clear message after showing
            <?php endif; ?>
        };
    </script>
</head>
<body>

<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenuAdmin.php"?>
    

<!-- The Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
  <?php include"login.php"?>
</div>


<script>
    // Get login status from PHP (true if logged in, false otherwise)
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    // Function to show the login modal
    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    // Execute after page loads
    window.onload = function () {
        // Show the modal only if the user is NOT logged in
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500); // Show after 2.5 seconds
        }
    };

    // Close the modal when clicking outside of it
    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>

    <div class="container">
    <h2>Manage Services</h2>
    </div>
    <table class="styled-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Service Name</th>
                <th>Price</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['service_name']}</td>
                        <td>£{$row['price']}</td>
                        <td>{$row['status']}</td>
                        <td>
                            <a href='edit_service.php?id=" . $row['id'] . "' class='button'>Edit</a> |
                            <a href='?delete_id=" . $row['id'] . "' class='button' 
                            onclick='return confirm(\"Are you sure you want to delete this service?\");'>Delete</a> |
                            <a href='toggle_status.php?id=" . $row['id'] . "' class='button' 
                            onclick='return confirm(\"Are you sure you want to change the status of this service?\");'>
                            " . ($row['status'] === 'active' ? 'Deactivate' : 'Activate') . "
                            </a>
                    </td>
                    </tr>";
                }
            } else {
                echo "<tr><td colspan='4'>No services available.</td></tr>";
            }
            ?>
        </tbody>
    </table>
    </div class="container">
    <center><a href="Add_service.php" class="button"  >Add New Service</a></center>
    </div>
    <br>
    <?php include"footer.php"?>

</body>
</html>
