<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

require_once __DIR__ . "/config/db.php";

// Handle search (PHP 5 compatible)
$search = isset($_GET['search']) ? $_GET['search'] : '';
// Handle search
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">

    <title>Cardiff Car Care</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include "header.php"; ?>

<div id="mySidepanel" class="sidepanel">
    <?php include "NavMenuAdmin.php"; ?>
</div>

<div class="container">
    <h2>View Messages</h2>

    <!-- 🔍 Search Form -->
    <form method="GET" action="manage_messages.php" style="margin-bottom:15px;">
        <input
            type="text"
            name="search"
            placeholder="Search name, email, or phone"
            value="<?php echo htmlspecialchars($search); ?>"
        >
        <button type="submit">Search</button>

    <?php
     if (!empty($search)) {
    echo '<a href="manage_messages.php" style="margin-left:10px;">Clear</a>';
    }
    ?>

    </form>
</div>

<?php
// Build query
if (!empty($search)) {
    $sql = "
        SELECT * FROM customer
        WHERE firstname LIKE ?
           OR lastname LIKE ?
           OR email LIKE ?
           OR phone LIKE ?
        ORDER BY contactid DESC
    ";
    $stmt = $conn->prepare($sql);
    $term = "%$search%";
    $stmt->bind_param("ssss", $term, $term, $term, $term);
} else {
    $sql = "SELECT * FROM customer ORDER BY contactid DESC";
    $stmt = $conn->prepare($sql);
}

$stmt->execute();
$result = $stmt->get_result();

echo "<table class='styled-table'>
        <tr>
            <th>Contact ID</th>
            <th>Firstname</th>
            <th>Lastname</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Address</th>
            <th>Postcode</th>
            <th>Message</th>
            <th>Status</th>
            <th>Action</th>
        </tr>";

while ($row = $result->fetch_assoc()) {
    if ($row['status'] === 'Unread') {
        $rowClass = 'unread-row';
    } else {
        $rowClass = 'read-row';
    }
    
    echo "<tr class='{$rowClass}'>
            <td>{$row['contactid']}</td>
            <td>{$row['firstname']}</td>
            <td>{$row['lastname']}</td>
            <td>{$row['phone']}</td>
            <td>{$row['email']}</td>
            <td>{$row['address']}</td>
            <td>{$row['postcode']}</td>
            <td>{$row['msg']}</td>
            <td>{$row['status']}</td>
            <td>
                <form action='process_msg_action.php' method='POST'>
                    <input type='hidden' name='contactid' value='{$row['contactid']}'>
                    <button name='action' value='Read'>Read</button>
                    <button name='action' value='Unread'>Unread</button>
                    <button name='action' value='delete' style='color:red;'>Delete</button>
                </form>
            </td>
          </tr>";
}

echo "</table>";

$stmt->close();
$conn->close();
?>

<?php include "footer.php"; ?>

</body>
</html>
