<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

$uploadDir = 'uploads/';
$selectionFile = 'selected_images.json';

// Load previous selections
$selectedImages = [];
if (file_exists($selectionFile)) {
    $selectedImages = json_decode(file_get_contents($selectionFile), true);
}

// Handle form submission via AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputData = json_decode(file_get_contents("php://input"), true);
    
    if (isset($inputData['selected_images'])) {
        file_put_contents($selectionFile, json_encode($inputData['selected_images']));
        echo json_encode(["success" => true]);
        exit();
    }
}

// Get all images in directory
$allImages = array_diff(scandir($uploadDir), ['.', '..']);

// Separate selected and unselected images
$unselectedImages = array_values(array_diff($allImages, $selectedImages));
$sortedImages = array_merge($selectedImages, $unselectedImages); // Selected first
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Gallery</title>
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>
</head>
<body>
<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenuAdmin.php"?>
    

<!-- The Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
  <?php include"login.php"?>
</div>


<script>
    // Get login status from PHP (true if logged in, false otherwise)
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    // Function to show the login modal
    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    // Execute after page loads
    window.onload = function () {
        // Show the modal only if the user is NOT logged in
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500); // Show after 2.5 seconds
        }
    };

    // Close the modal when clicking outside of it
    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>

<div class="container">

<h2>Manage Gallery</h2>

<!-- Form for image selection and ordering -->
<form id="gallery-mgr-form">
    <div id="gallery-mgr-container" class="gallery-mgr-container">
        <?php foreach ($sortedImages as $image): ?>
            <div class="gallery-mgr-item" data-image="<?php echo $image; ?>">
                <input type="checkbox" class="gallery-mgr-checkbox" name="selected_images[]" value="<?php echo $image; ?>" 
                    <?php echo in_array($image, $selectedImages) ? 'checked' : ''; ?>>
                <img class="gallery-mgr-image" src="<?php echo $uploadDir . $image; ?>" alt="Gallery Image">
            </div>
        <?php endforeach; ?>
    </div>
    <center> <button class="gallery-mgr-btn" type="submit">Save Selection & Order</button></center>
</form>

<script>
    // Make gallery sortable
    new Sortable(document.getElementById('gallery-mgr-container'), {
        animation: 150,
        ghostClass: 'gallery-mgr-dragging'
    });

    // Save order and selection via AJAX
    document.getElementById('gallery-mgr-form').addEventListener('submit', function(event) {
        event.preventDefault();
        
        let selectedImages = [];
        document.querySelectorAll('.gallery-mgr-item').forEach(item => {
            let checkbox = item.querySelector('.gallery-mgr-checkbox');
            if (checkbox.checked) {
                selectedImages.push(item.dataset.image);
            }
        });

        fetch("", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ selected_images: selectedImages })
        }).then(response => response.json()).then(data => {
            if (data.success) {
                alert("Gallery updated successfully!");
            }
        });
    });
</script>
</div>
<?php include "footer.php" ?>

</body>
</html>
 