<?php
session_start(); // Start the session
$isLoggedIn = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true; // allows for login modal to display after 2.5 seconds 

// Check if the user is logged in
if (!isset($_SESSION['loggedin'])) {
    $_SESSION['role'] = 'guest'; // Assign guest role
}
?>       

<!DOCTYPE html>
<html lang="en">
<head>  
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
        <title>Cameron's Auto Care</title>
        <link rel="icon" type="image/x-icon" href="/my-app/uploads/Cameronsautocare.png">
    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<!-- Hidden Admin Login Button -->


<body>

<?php include"header.php"?>


  <!-- NAVIGATION -->
<div id="mySidepanel" class="sidepanel">
    <?php include "NavMenu.php"; ?>
</div>

<button class="openbtn" onclick="openNav()">☰ Menu</button>

<script>
function openNav() {
  document.getElementById("mySidepanel").style.width = "250px";
}

function closeNav() {
  document.getElementById("mySidepanel").style.width = "0";
}

const logoutLink = document.querySelector("a[href='contact.php?logout=true']");
if (logoutLink) {
  logoutLink.onclick = function() {
    closeNav();
  };
}
</script>


<!-- contact button-->
<a href="Contact.php" class="button-contact" target = "_self" >Contact Us</a>

<section class="hero">
    <div>
        Professional Car Detailing</div>
</section>

<div class="container">

    <!-- Services Section -->
    <section id="services" class="services">
        <h2>Our Services</h2>
        <div class="service-grid">
            <div class="service-item">
                <h3>Exterior Detailing</h3>
                <p>Make your car shine like new with our expert exterior detailing services.</p>
            </div>
            <div class="service-item">
                <h3>Interior Detailing</h3>
                <p>We clean every inch of your car's interior for a fresh, spotless look.</p>
            </div>
            <div class="service-item">
                <h3>Ceramic Coating</h3>
                <p>Protect your car's paint with long-lasting ceramic coating.</p>
            </div>
           
            
        </div>
            <center><a href="Services.php" class="button" target="_self">LEARN MORE </a></center>
    </section>

    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials">
        <h2>What Our Customers Say</h2>
        <div class="testimonial-item">
            <p>"Cameron did an amazing job with our truck Very satisfied customer" - Audrey.</p>
        </div>
        <div class="testimonial-item">
            <p>"An excellent job done on a very dirty car. Cam spent a few hours cleaning inside and outside to a very high standard. Well worth the money he charged. Thank you!" - Jackie.</p>
        </div>
        <div class="testimonial-item">
            <p>"Attention to detail is incredible. I won’t go anywhere else for detailing." - Josh.</p>
        </div>

    </section>

    <!-- Gallery Section -->
    <h2>Photo Gallery</h2>
    <section id="gallery" class="gallery">
        <img src="/my-app/uploads/tesla side.JPEG" alt="Car Detailing 1">
        <img src="/my-app/uploads/BMW front side.jpg" alt="Car Detailing 2">
        <img src="/my-app/uploads/capture back seats.JPEG" alt="Car Detailing 3">
        <img src="/my-app/uploads/range door.jpg" alt="Car Detailing 4">
    </section>
    <hr>
    <!-- Contact Section -->
    <section id="contact" class="contact-text">
        <h2>Contact Us</h2>
        <p> Cardiff, Wales</p>
        <p> <i style="font-size:30px" class="fa">&#xf095;</i><span style= "padding-left: 15px;">07421056698</span></p>
        <p> <i style="font-size:30px" class="fa">&#xf0e0;</i><span style= "padding-left: 15px;"><a href="mailto:cameronclark1407@icloud.com">cameronclark1407@icloud.com</a></span></p>
        </section>
        <br>
        <centre><a href="Contact.php" class="button-contact-still" target = "_self" ><i style = "font-size:20px" class="fa">&#x1F604;</i><span style = "padding-left:10px;">Contact Us</a></span></centre>

   

</div>


<?php include"footer.php"?>

<!-- Hidden Admin Login Trigger -->
<div id="adminTrigger" style="position:fixed; bottom:10px; right:10px; width:20px; height:20px; opacity:0; z-index:9999; cursor:pointer;"></div>

<!-- Hidden Admin Login Form -->
<form id="adminLoginForm" action="login.php" method="GET" style="display:none;">
    <button type="submit" id="adminLoginBtn"></button>
</form>
<script>
document.addEventListener("DOMContentLoaded", function() {
    var clicks = 0;
    var trigger = document.getElementById("adminTrigger");
    var adminBtn = document.getElementById("adminLoginBtn");

    if (!trigger || !adminBtn) return;

    trigger.addEventListener("click", function() {
        clicks++;
        if (clicks === 3) { // 3 clicks triggers admin login
            adminBtn.click();
        }
        // reset clicks after 1.5 seconds
        setTimeout(function() { clicks = 0; }, 1500);
    });
});
</script>




</html>