<?php
session_start(); // Start the session

// Check if the user is logged in
if (!isset($_SESSION['loggedin'])) {
    $_SESSION['role'] = 'guest'; // Assign guest role
}

$uploadDir = 'uploads/';
$selectionFile = 'selected_images.json';

// Load selected images
$selectedImages = [];
if (file_exists($selectionFile)) {
    $selectedImages = json_decode(file_get_contents($selectionFile), true);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    <title>Cameron's Auto Care</title>
    <link rel="icon" type="image/x-icon" href="/my-app/uploads/Cameronsautocare.png">

    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include"header.php"?>


<!-- NAVIGATION -->
<div id="mySidepanel" class="sidepanel">
    <?php include "NavMenu.php"; ?>
</div>

<button class="openbtn" onclick="openNav()">☰ Menu</button>

<script>
function openNav() {
  document.getElementById("mySidepanel").style.width = "250px";
}

function closeNav() {
  document.getElementById("mySidepanel").style.width = "0";
}

const logoutLink = document.querySelector("a[href='contact.php?logout=true']");
if (logoutLink) {
  logoutLink.onclick = function() {
    closeNav();
  };
}
</script>

    <div class="container">
    <h2>Photo Gallery</h2>
    <section id="gallery" class="gallery">
    <?php if (!empty($selectedImages)): ?>
        <?php foreach ($selectedImages as $index => $image): ?>
            <img src="<?php echo $uploadDir . $image; ?>" alt="Gallery Image">


        <?php endforeach; ?>
    <?php else: ?>
        <p>No images available in the gallery.</p>
    <?php endif; ?>
</section>
    
    <hr>
    <!-- Contact Section -->
    <section id="contact" class="contact-text">
        <h2>Contact Us</h2>
        <p> Cardiff, Wales</p>
        <p> <i style="font-size:30px" class="fa">&#xf095;</i><span style= "padding-left: 15px;">07421056698</span></p>
        <p> <i style="font-size:30px" class="fa">&#xf0e0;</i><span style= "padding-left: 15px;"><a href="cameronclark1407@icloud.com">cameronclark1407@icloud.com</a></span></p>
        </section>
        <br>
        <centre><a href="Contact.php" class="button-contact-still" target = "_self" ><i style = "font-size:20px" class="fa">&#x1F604;</i><span style = "padding-left:10px;">Contact Us</a></span></centre>
        </div>

    <?php include"footer.php"?>

</body>
</html>
