<?php
require_once __DIR__ . '/config/db.php';    // your InfinityFree DB connection
require_once __DIR__ . '/config/mail.php';  // PHPMailer setup

// -------------------------
// Helper function to sanitize input
// -------------------------
function clean($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// -------------------------
// Honeypot spam protection
// -------------------------
if (!empty($_POST['website'])) {
    exit; // bot detected
}

// -------------------------
// Collect form data
// -------------------------
$firstname = isset($_POST['firstname']) ? clean($_POST['firstname']) : '';
$lastname  = isset($_POST['lastname']) ? clean($_POST['lastname']) : '';
$phone     = isset($_POST['phone']) ? clean($_POST['phone']) : '';
$email     = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) : '';
$address   = isset($_POST['address']) ? clean($_POST['address']) : '';
$postcode  = isset($_POST['postcode']) ? clean($_POST['postcode']) : '';
$message   = isset($_POST['msg']) ? clean($_POST['msg']) : '';

if (!$firstname || !$lastname || !$email || !$message) {
    die("Invalid submission.");
}

// -------------------------
// Save to database
// -------------------------
$stmt = $conn->prepare("
    INSERT INTO customer
    (firstname, lastname, phone, email, address, postcode, msg)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    die("Database prepare failed: " . $conn->error);
}

$stmt->bind_param(
    "sssssss",
    $firstname, $lastname, $phone, $email, $address, $postcode, $message
);

if (!$stmt->execute()) {
    die("Database execute failed: " . $stmt->error);
}

// -------------------------
// -------------------------
try {
    // Email to site owner
    $mail = getMailer();
    $mail->setFrom('no-reply@cameronsautocare.org', 'Camerons Auto Care');
    $mail->addAddress('cameronclark1407@icloud.com'); // admin
    $mail->addReplyTo($email); // user reply
    $mail->Subject = "New Contact Message from $firstname $lastname";
    $mail->Body = $message;
    $mail->send();

    // Confirmation email to user
    $mail = getMailer();
    $mail->setFrom('no-reply@cameronsautocare.org', 'Camerons Auto Care');
    $mail->addAddress($email);
    $mail->Subject = "Thanks for contacting us";
    $mail->Body = "Hi $firstname,\n\nWe’ve received your message and will get back to you soon.";
    $mail->send();

} catch (Exception $e) {
    // Optional: log errors for debugging
    error_log("Mailer Error: " . $e->getMessage());
}

// Redirect on success
header("Location: contact.php?success=1");
exit;

