<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php"); // Redirect non-admins
    exit();
}

// Connect to the database
require_once __DIR__ . "/config/db.php";


// Fetch the total number of unread messages
$total_unread_messages = 0; // Default value
$sql = "SELECT COUNT(*) as unread_count FROM customer WHERE status = 'Unread'"; 
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_unread_messages = $row['unread_count'];
}

// Fetch the total number of users
$total_users = 0; // Default value
$sql = "SELECT COUNT(*) as total_users FROM signup"; 
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_users = $row['total_users'];
}

// Fetch the total number of services
$total_services = 0; // Default value
$sql = "SELECT COUNT(*) as total_services FROM services"; 
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_services = $row['total_services'];
}

// Fetch the total number of reviews
$total_reviews = 0; // Default value
$sql = "SELECT COUNT(*) as total_reviews FROM reviews"; 
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_reviews = $row['total_reviews'];
}


// Fetch the total number of pending bookings
$total_pending_bookings = 0; // Default value
$sql = "SELECT COUNT(*) as pending_count FROM bookings WHERE approval_status = 'pending'"; 
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_pending_bookings = $row['pending_count'];
}


$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    
        <title>Cameron's Auto Care</title>
        <link rel="icon" type="image/x-icon" href="/my-app/uploads/Cameronsautocare.png">

    
    <!-- Font Awesome for Social Media Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>

<?php include"header.php"?>


    <div id="mySidepanel" class="sidepanel">
    <?php include"NavMenuAdmin.php"?>
    

<!-- The Modal -->
<div id="loginModal" class="modal-login" style="display: none;">
  <?php include"login.php"?>
</div>


<script>
    // Get login status from PHP (true if logged in, false otherwise)
    var isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

    // Function to show the login modal
    function showLoginModal() {
        var loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.style.display = 'block';
        }
    }

    // Execute after page loads
    window.onload = function () {
        // Show the modal only if the user is NOT logged in
        if (!isLoggedIn) {
            setTimeout(showLoginModal, 2500); // Show after 2.5 seconds
        }
    };

    // Close the modal when clicking outside of it
    window.onclick = function (event) {
        var loginModal = document.getElementById('loginModal');
        if (event.target === loginModal) {
            loginModal.style.display = 'none';
        }
    };
</script>


<div class="container-admin">
    <br>
    <h2>Admin Dashboard</h2>
    <div class="dashboard-admin">
        <!-- Home Card -->
        <div class="card-admin">
            <a href="Home.php"><i class="fas fa-home"></i></a>
            <h3>Home</h3>
            <a href="Home.php">Go to Home</a>
        </div>
        <!-- Services Card -->
        <div class="card-admin">
            <a href="Manage_services"><i class="fas fa-cogs"></i></a>
            <h3>Manage Services</h3>
            <a href="Manage_services.php">View Services</a>
            <br><br>
            <span class="count-admin"><?php echo $total_services; ?></span>

        </div>
        
        <!-- Users Card -->
        <div class="card-admin">
            <a href="Manage_users.php"><i class="fas fa-users"></i></a>
            <h3>Manage Users</h3>
            <a href="Manage_users.php">View Users</a>
            <br><br>
            <span class="count-admin"><?php echo $total_users; ?></span>
        </div>
        <!-- Messages Card -->
        <div class="card-admin">
            <a href="Manage_message.php"><i class="fas fa-envelope"></i></a>
            <h3>Messages</h3>
            <a href="Manage_messages.php">View Messages</a>
            <br><br>
            <span class="count-admin"><?php echo $total_unread_messages; ?></span>

        </div>
        <!-- Gallery Card -->
        <div class="card-admin">
            <a href="Manage_gallery.php"><i class="fas fa-images"></i></a>
            <h3>Manage Gallery</h3>
            <a href="Manage_gallery.php">View Gallery</a>
            <br><br>
            <span class="count-admin">📸</span> <!-- No numerical data yet, so using an icon -->
        </div>

        <!-- upload Card -->
        <div class="card-admin">
            <i class="fas fa-upload"></i>
            <h3>Upload Image</h3>
            <a href="upload_image.php">Image Upload</a>
            <br><br>
        </div>
    </div>
</div>
<?php include"footer.php"?>

</body>
</html>