<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: Home.php");
    exit();
}

require_once __DIR__ . "/config/db.php";


// Get images from 'uploads/' directory
$uploads_dir = "uploads/";
$images = array_diff(scandir($uploads_dir), array('..', '.'));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="my-style.css">
    <link rel="stylesheet" href="login.css">
    <title>Cardiff Car Care</title>
    <script src="https://cdn.tiny.cloud/1/gbww066ri5k6yqv0ic4r985zd20zifcrlav1avihz63conj8/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea#service_description',
        menubar: false,
        plugins: 'advlist autolink lists link charmap preview',
        toolbar: 'bold italic underline | bullist numlist | alignleft aligncenter alignright',
        content_style: "body { font-family: Arial; font-size: 14px; }",
        setup: function(editor) {
            editor.on('change', function() {
                editor.save();
            });
        }
    });
    </script>
</head>
<body>
<?php include "header.php"; ?>

<div class="container">
    <h2>Add Service</h2>

    <?php
    if (isset($_SESSION['error_message'])) {
        echo "<p style='color:red;'>" . $_SESSION['error_message'] . "</p>";
        unset($_SESSION['error_message']);
    }
    if (isset($_SESSION['success_message'])) {
        echo "<p style='color:green;'>" . $_SESSION['success_message'] . "</p>";
        unset($_SESSION['success_message']);
    }
    ?>

    <form action="Process_service_add_action.php" method="POST">
        <label for="service_name">Service Name:</label>
        <input type="text" id="service_name" name="service_name" required>

        <label for="service_overview">Service Overview:</label>
        <textarea id="service_overview" name="service_overview" rows="4" required></textarea>

        <label for="service_description">Detailed Description:</label>
        <textarea id="service_description" name="detailed_description" rows="15" required></textarea>

        <label for="price">Price (£):</label>
        <input type="number" id="price" name="price" step="0.01" required>

        <label for="selected_image">Select Image:</label>
        <select id="selected_image" name="selected_image" required>
            <option value="">-- Select an Image --</option>
            <?php
            foreach ($images as $image) {
                echo "<option value='$image'>$image</option>";
            }
            ?>
        </select>

        <input type="submit" name="action" value="Add Service">
    </form>
</div>

<?php include "footer.php"; ?>
</body>
</html>
